/* global sc */

let $$ = require('./debug')({ debug: true, path: module.id, prefix: '[cdev.ncore - asa]' });
$$.mdb = require('./mdb')($$);
$$.fs = require('./fs')($$);
$$.yaml = require('../yaml')($$);

$$.objects = require('common/objects').sc($$.environment.context || sc);
$$.beans = require('common/beans');
$$.metadb = require('common/metadb');

const profilesPath = 'MAIN_MODULE_MANAGEMENT/filingassistant/2.0/control';

function dumpAsaProfile(profile, root) {
  let asa = $$.mdb.load(profilesPath + '/' + profile);

  if (!(asa && 'active' in asa && 'version' in asa)) return;

  let currentStamp = asa.version;

  if (typeof root === 'string') root = $$.objects.find(root);

  $$.debug('dumpAsaProfile [{0}] to [{1}] ...'.format(profile, root.anyFolderPath));

  let target = root.createPath(profile);

  let config = target.getItem('config.json');
  if (config) {
    let lastStamp = JSON.parse($$.beans.get(config, 'content')).version;
    if (currentStamp <= lastStamp) {
      $$.debug(
        'dumpAsaProfile skipped: current timestamp [{0}] lower or equal than last timestamp [{0}]'.format(
          new Date(currentStamp),
          new Date(lastStamp)
        )
      );
      return;
    }
  }

  let jsTokens = ['jsInit', 'jsAction', 'jsAfter', 'jsBefore'];

  ['Actions', 'Filing', 'Structure'].forEach(section => {
    if (asa[section]) {
      asa[section].forEach(action => {
        Object.keys(action).forEach(key => {
          if (jsTokens.indexOf(key) > -1) {
            let script = action[key];
            delete action[key];

            let fname = action.name + '_' + key + '.js';
            $$.debug('dumpAsaProfile [{0}]'.format(fname));
            $$.fs.createFile({
              name: fname,
              target: target.createPath(section),
              content: script,
              update: true,
            });
          }
        });

        let fname = action.name + '_' + 'config' + '.json';
        $$.debug('dumpAsaProfile [{0}]'.format(fname));
        $$.fs.createFile({
          name: fname,
          target: target.createPath(section),
          content: JSON.stringify(action, null, 4),
          update: true,
        });
      });

      delete asa[section];
    }
  });

  $$.fs.createFile({
    name: 'config.json',
    target: target,
    content: JSON.stringify(asa, null, 4),
    update: true,
  });
  $$.debug('dumpAsaProfile finished with [{0}] at [{1}] ...'.format(profile, root.anyFolderPath));
}

function AddOns() {
  let asa = $$.mdb.load(profilesPath);
  delete asa.AddOns.active;

  // Object.keys(asa.AddOns).forEach( profile => {
  //    dumpAsaProfile('AddOns/' + profile, target);
  // });

  return asa.AddOns;
}

function Profiles() {
  let asa = $$.mdb.load(profilesPath);
  delete asa.AddOns;

  // Object.keys(asa).forEach( profile => {
  //  dumpAsaProfile(profile, target);
  // });

  return asa;
}

function exportYaml(exportFile) {
  // $$.debug('exportYaml:' + exportFile.name);
  let result = {};
  $$.yaml.read(exportFile).forEach(record => {
    let key = Object.keys(record)[0];
    if (!result[key]) result[key] = [];
    result[key].push(record[key]);
  });
  return result['Smart Assistant'];
}

function dumpProfilesByCustomer(_customers) {
  $$.debug('dumpProfilesByCustomer', _customers);
  let asaProfiles = Object.keys(Profiles());
  let asaAddOns = Object.keys(AddOns());
  let customers;

  // Handle different input types
  if (!_customers) {
    customers = $$.objects.find('/agorum/roi/customers').items();
  } else {
    // Convert single string to array
    if (typeof _customers === 'string') {
      _customers = [_customers];
    }
    // Map paths to customer objects
    customers = _customers.map(path => $$.objects.find('/agorum/roi/customers/' + path));
  }

  customers.forEach(customer => {
    if (!customer.isFolder) {
      return;
    }

    $$.debug('dumpProfilesByCustomer - customer: ' + customer.anyFolderPath);

    $$.objects
      .query('inpath:' + customer.ID + ' name_ci:export*.yml')
      .find()
      .forEach(exportFile => {
        let yaml = exportYaml(exportFile.anyFolderPath);

        if (yaml) {
          yaml.forEach(asaProfile => {
            if (asaProfiles.indexOf(asaProfile) > -1) {
              dumpAsaProfile(asaProfile, customer.createPath('[asa]'));
            }
            if (asaAddOns.indexOf(asaProfile) > -1) {
              dumpAsaProfile('AddOns/' + asaProfile, customer.createPath('[asa]'));
            }
          });
        }
      });
  });
}

function dumpProfilesByFilingAssistant() {
  let target = $$.objects.find('/agorum/roi/workspace/cdev.ncore').createPath('[AsaConfig]');
  let asa = $$.mdb.load(profilesPath);

  Object.keys(asa.AddOns).forEach(profile => {
    if (profile !== 'active') dumpAsaProfile('AddOns/' + profile, target);
  });

  delete asa.AddOns;

  Object.keys(asa).forEach(profile => {
    dumpAsaProfile(profile, target);
  });
}

function active(profile) {
  return profile.active === 'true';
}

function activate(profile, value) {
  let prof = $$.mdb.load(profilesPath + '/' + profile);
  if (prof && prof.active && active(prof) !== value) {
    $$.debug('activate: {0}: current={1} new={2}'.format(profilesPath, prof.active[0], value.toString()));
    throw 'asa.activate() not implemented!';
    // TODO: further testing required before writing a single value to MetaDb !!
    // $$.saveToMetaDb(profilesPath + '/' + profile, {active: value.toString()});
  }
}

function toggleActive(_profile, value) {
  // set active property and(!) comment/uncomment keys, see
  // actempman/js/utils/set-asa-addon-active-inactive.js
  // for details
  let comkey = '#actempman_inactive_';
  let ignoreKeys = {
    version: true,
    active: true,
    format: true,
    isAddOn: true,
  };
  let profilePath = profilesPath + '/' + _profile;
  let profile = $$.metadb.read(profilePath);
  $$.debug(Object.keys(profile));
  let active = profile['active'][0];
  if (active !== value.toString()) {
    $$.debug('toggle profile [{0}]: current={1} new={2}'.format(profilePath, active, value.toString()));
    Object.keys(profile)
      .filter(key => !ignoreKeys[key])
      .forEach(key => {
        let obj = profile[key];
        if (value) {
          // activate profile
          if (key.startsWith('#')) {
            profile[key.replace(comkey, '')] = obj;
            profile[key] = null;
          }
        } else {
          // disable profile
          if (!key.startsWith('#')) {
            profile[comkey + key] = obj;
            profile[key] = null;
          }
        }
      });
    profile.version = Date.now().toFixed(0);
    profile.active = [value.toString()];
    $$.metadb.write(profilePath, profile);
    $$.debug($$.metadb.read(profilePath));
  }
}

function getProfilePath(asaProfile) {
  let asaProfiles = Object.keys(Profiles());
  let asaAddOns = Object.keys(AddOns());
  let result = [];

  if (asaProfiles.indexOf(asaProfile) > -1) result.push(asaProfile);
  if (asaAddOns.indexOf(asaProfile) > -1) result.push('AddOns/' + asaProfile);

  return result;
}

module.exports = {
  dumpAsaProfile: dumpAsaProfile,
  dumpProfilesByCustomer: dumpProfilesByCustomer,
  dumpProfilesByFilingAssistant: dumpProfilesByFilingAssistant,
  AddOns: AddOns,
  Profiles: Profiles,
  active: active,
  activate: activate,
  toggleActive: toggleActive,
  getProfilePath: getProfilePath,
};
